package cz.frantovo.nekurak.util;

import cz.frantovo.nekurak.vyjimky.KomentarovaVyjimka;
import org.junit.Test;
import static org.junit.Assert.*;

public class KomentareTest {

	Komentare komentare = new Komentare();

	@Test
	public void obal() {
		String vystup = Komentare.obal("asdf");
		String pozadovanyVystup = "<div>asdf</div>";
		assertEquals(pozadovanyVystup, vystup);
	}

	@Test
	public void upravProstýTextObal() {
		String vystup = Komentare.upravProstyText("as\ndf");
		vystup = Komentare.obal(vystup);
		String pozadovanyVystup = "<div><p>as<br/>df</p></div>";
		assertEquals(pozadovanyVystup, vystup);
	}

	@Test
	public void komentáře() throws KomentarovaVyjimka {
		/**
		 * Komentáře jsou povolené. TODO: OK?
		 */
		String výstup = Komentare.upravProstyText("aaa<!-- komentář -->bbb");
		výstup = Komentare.obal(výstup);
		komentare.zkontroluj(výstup);
	}

	@Test
	public void zvláštníZnaky() {
		String vystup = Komentare.upravProstyText("nbusr123 & | and < … > uvo\"zovky'");
		String pozadovanyVystup = "<p>nbusr123 &amp; | and &lt; … &gt; uvo&quot;zovky&apos;</p>";
		assertEquals(pozadovanyVystup, vystup);
	}

	@Test
	public void xmlJednoduché() throws Exception {
		komentare.zkontroluj("<div><p>xxx</p></div>");
		komentare.zkontroluj("<div><p>xxx</p><p>xxx</p></div>");
		komentare.zkontroluj("<div><p>xxx<strong>tučně</strong>xxx</p></div>");
		komentare.zkontroluj("<div><p>xxx<em>tučně</em>xxx</p></div>");
	}

	@Test(expected = KomentarovaVyjimka.class)
	public void xmlChybaÚplněŠpatnéXML() throws Exception {
		komentare.zkontroluj("<div>xxx</p></div>");
	}

	@Test(expected = KomentarovaVyjimka.class)
	public void xmlChybaChybíOdstavec() throws Exception {
		komentare.zkontroluj("<div>xxx</div>");
	}

	@Test(expected = KomentarovaVyjimka.class)
	public void xmlChybaPřebýváAtribut() throws Exception {
		komentare.zkontroluj("<div omfg='xxx'><p>xxx</p></div>");
	}
}
