package cz.frantovo.nekurak.util;

import org.junit.Test;
import static org.junit.Assert.*;

/**
 * Kromě Hashe otestujeme i to, zda správně fungují i názvy metod napsané česky :-)
 *
 * <blockquote>
 * „Letters and digits may be drawn from the entire Unicode character set,
 * which supports most writing scripts in use in the world today,
 * including the large sets for Chinese, Japanese, and Korean.
 * This allows programmers to use identifiers in their programs that are written in their native languages.“
 * </blockquote>
 *
 * @see <a href="http://java.sun.com/docs/books/jls/third_edition/html/lexical.html#40625">Java Language Specification – 3.8 Identifiers</a>
 * @author fiki
 */
public class HashTest {

	String 外滩 = "Bund";
	String 南京东路 = "Nanjing Road East";

	@Test
	public void prázdnýŘetězec() throws Exception {
		testuj("", "cf83e1357eefb8bdf1542850d66d8007d620e4050b5715dc83f4a921d36ce9ce47d0d13c5d85f2b0ff8318d2877eec2f63b931bd47417a81a538327af927da3e");
	}

	@Test
	public void prázdnýŘádek() throws Exception {
		testuj("\n", "be688838ca8686e5c90689bf2ab585cef1137c999b48c70b92f67a5c34dc15697b5d11c982ed6d71be1e1e7f7b4e0733884aa97c3f7a339a8ed03577cf74be09");
	}

	@Test(expected = NullPointerException.class)
	public void nullHodnota() throws Exception {
		testuj(null, "Při null vstupu má být vyhozena NullPointerException.");
	}

	@Test
	public void něco() throws Exception {
		testuj("Ahoj, jak to jde? :-)", "87e6e3c6487dc5ffee93d05cdc71a196f21181e357e61e1820d652ed9b601e179db92c1aaafc9cf57384498c1a52b89c82714dabdfd30b9eb8c7fd8d3fe53685");
	}

	@Test
	public void čeština() throws Exception {
		testuj("čeština a další unicode – → | @{#@$%${*&…˙××„东方明珠塔“‚&‘‚“‚", "f9750a7f3fa04356510285af61bbdd40b108e04c2abad69130c5929561fa2765e263707147f779ac5f4be348005ce0fc810334822ba0a50f1d5c41719413277e");
	}

	private void testuj(String vstup, String pozadovanyVystup) throws Exception {
		String vystup = Hash.hashuj(vstup);
		assertEquals(pozadovanyVystup, vystup);
	}
}
