package cz.frantovo.nekurak.dto;

import org.junit.Test;
import static org.junit.Assert.*;

public class PodnikTest {

	@Test
	public void testGetDomena() {
		zkontrolujDoménu("http://www.example.com/index.html", "www.example.com");
		zkontrolujDoménu("http://www.eXample.COM/index.html", "www.example.com");
		zkontrolujDoménu("https://paranoid.cz/index.html", "paranoid.cz");
		zkontrolujDoménu("http://frantovo.cz", "frantovo.cz");
		zkontrolujDoménu("ftp://ftp.frantovo.cz", "ftp.frantovo.cz");
		zkontrolujDoménu("http://čeština.frantovo.cz/xxx/ZZZ", "čeština.frantovo.cz");
		zkontrolujDoménu("example.com", null);
		zkontrolujDoménu("./soubor.txt", null);
		zkontrolujDoménu("file:///etc/passwd", null);
		zkontrolujDoménu("", null);
		zkontrolujDoménu(null, null);
	}

	private void zkontrolujDoménu(String url, String očekávanáDoména) {
		Podnik p = new Podnik();
		p.setUrl(url);
		assertEquals(očekávanáDoména, p.getUrlDomena());

	}
}
