package cz.frantovo.nekurak.web;

import cz.frantovo.nekurak.ejb.ClanekRemote;
import cz.frantovo.nekurak.ejb.PodnikRemote;
import cz.frantovo.nekurak.ejb.UzivatelRemote;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

/**
 *
 * @author fiki
 */
public class HledacSluzby implements Serializable {

	private PodnikRemote podnikEJB;
	private UzivatelRemote uzivatelEJB;
	private ClanekRemote clanekEJB;
	private static final Logger log = Logger.getLogger(HledacSluzby.class.getSimpleName());

	public PodnikRemote getPodnikEJB() {
		if (podnikEJB == null) {
			try {
				Context c = new InitialContext();
				podnikEJB = (PodnikRemote) c.lookup("cz.frantovo.nekurak.ejb.PodnikRemote");
			} catch (NamingException e) {
				log.log(Level.SEVERE, "Chyba při hledání PodnikRemote", e);
				throw new RuntimeException(e);
			}
		}
		return podnikEJB;
	}

	public UzivatelRemote getUzivatelEJB() {
		if (uzivatelEJB == null) {
			try {
				Context c = new InitialContext();
				uzivatelEJB = (UzivatelRemote) c.lookup("cz.frantovo.nekurak.ejb.UzivatelRemote");
			} catch (NamingException e) {
				log.log(Level.SEVERE, "Chyba při hledání UzivatelRemote", e);
				throw new RuntimeException(e);
			}
		}
		return uzivatelEJB;
	}

	public ClanekRemote getClanekEJB() {
		if (clanekEJB == null) {
			try {
				Context c = new InitialContext();
				clanekEJB = (ClanekRemote) c.lookup("cz.frantovo.nekurak.ejb.ClanekRemote");
			} catch (NamingException e) {
				log.log(Level.SEVERE, "Chyba při hledání ClanekRemote", e);
				throw new RuntimeException(e);
			}
		}
		return clanekEJB;
	}
}
