package cz.frantovo.nekurak.util;

import cz.frantovo.nekurak.vyjimky.KomentarovaVyjimka;
import java.io.ByteArrayInputStream;
import java.net.URL;
import java.util.logging.Logger;
import javax.xml.XMLConstants;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/**
 * Validátor komentářů
 * @author fiki
 */
public class Komentare {

	private static final Logger log = Logger.getLogger(Komentare.class.getSimpleName());

	/**
	 * Escapuje XML a doplní XHTML zalomení na konce řádků.
	 * @param komentar prostý text zadaný uživatelem
	 * @return XHTML komentář bez kořenového elementu
	 */
	public static String upravProstyText(String komentar) {
		return zalomRadky(escapujXML(komentar));
	}

	/**
	 * Pokud uživatel zapomněl na odstavce,
	 * zalomíme řádky a zabalíme celý odstavec do jednoho odstavce
	 * @param komentar komentář bez odstavců
	 * @return komentář s odstavci
	 */
	public static String upravXHTML(String komentar) {
		if (komentar.indexOf("<p>") == -1) {
			return zalomRadky(komentar);
		} else {
			return komentar;
		}
	}

	/**
	 * Převede konce řádků na &lt;br/&gt;
	 * a celé zabalí do &lt;p/&gt;
	 * @param komentar text se zalomenými řádky
	 * @return text s &lt;br/&gt; místo konců řádků
	 */
	private static String zalomRadky(String komentar) {
		return "<p>" + komentar.replaceAll("\n", "<br/>") + "</p>";
	}

	/**
	 *
	 * @param komentar vstupní XHTML
	 * @return XHTML obalené kořenovým elementem
	 */
	public static String obal(String komentar) {
		return "<div>" + komentar + "</div>";
	}

	/**
	 * zkontroluje komentář oproti schématu.
	 *
	 * TODO: omezit maximální délku?
	 * TODO: omezit komentáře?
	 *
	 * @param komentar
	 * @return jestli komentář odpovídá
	 */
	public static Document zkontroluj(String komentar) throws KomentarovaVyjimka {
		try {
			URL soubor = Komentare.class.getClassLoader().getResource("cz/frantovo/nekurak/util/komentář.xsd");
			SchemaFactory tovarnaSchemat = SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);
			Schema schema = tovarnaSchemat.newSchema(soubor);

			DocumentBuilderFactory tovarnaDB = DocumentBuilderFactory.newInstance();
			tovarnaDB.setSchema(schema);

			DocumentBuilder db = tovarnaDB.newDocumentBuilder();
			db.setErrorHandler(new ErrorHandler() {

				@Override
				public void warning(SAXParseException e) throws SAXException {
					throw e;
				}

				@Override
				public void error(SAXParseException e) throws SAXException {
					/**
					 * neodpovídá schématu
					 * TODO: poslat hlášku, v čem je chyba
					 */
					throw e;
				}

				@Override
				public void fatalError(SAXParseException e) throws SAXException {
					/** invalidní XML – neuzavřené značky atd. */
					throw e;
				}
			});
			Document dokument = db.parse(new ByteArrayInputStream(komentar.getBytes("UTF-8")));
			return dokument;
		} catch (Exception e) {
			throw new KomentarovaVyjimka("Neplatný komentář: " + komentar, e);
		}


	}

	private static String escapujXML(String str) {
		return str.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;").replaceAll("'", "&apos;");
	}
}
