package cz.frantovo.nekurak.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * Pomocná třída pro počítání hashů.
 * @author fiki
 */
public class Hash {

	private static String algoritmus = "SHA-512";
	private static String kodovani = "UTF-8";

	private static String prevedNaHex(byte[] data) {
		StringBuilder vysledek = new StringBuilder();
		for (int i = 0; i < data.length; i++) {
			int pulBajt = (data[i] >>> 4) & 0x0F;
			int dvePulky = 0;
			do {
				if ((0 <= pulBajt) && (pulBajt <= 9)) {
					vysledek.append((char) ('0' + pulBajt));
				} else {
					vysledek.append((char) ('a' + (pulBajt - 10)));
				}
				pulBajt = data[i] & 0x0F;
			} while (dvePulky++ < 1);
		}
		return vysledek.toString();
	}

	/**
	 * @param text vstupní text
	 * @return hashovaný text v HEX tvaru
	 * @throws NoSuchAlgorithmException neexistující hashovací algoritmus
	 * @throws UnsupportedEncodingException nepodporované kódování znaků
	 * @throws NullPointerException pokud je vstup null
	 */
	public static String hashuj(String text) throws NoSuchAlgorithmException, UnsupportedEncodingException {
		MessageDigest md;
		md = MessageDigest.getInstance(algoritmus);
		byte[] hash = new byte[40];
		md.update(text.getBytes(kodovani), 0, text.length());
		hash = md.digest();
		return prevedNaHex(hash);
	}
}
