package cz.frantovo.nekurak.ejb;

import cz.frantovo.nekurak.dto.Kategorie;
import cz.frantovo.nekurak.dto.Komentar;
import cz.frantovo.nekurak.dto.Kurackost;
import cz.frantovo.nekurak.dto.Podnik;
import cz.frantovo.nekurak.dto.VysledekHlasovani;
import cz.frantovo.nekurak.vyjimky.KomentarovaVyjimka;
import cz.frantovo.nekurak.vyjimky.WikiSyntaxVyjimka;
import java.util.Collection;
import javax.ejb.Remote;

/**
 *
 * @author fiki
 */
@Remote
public interface PodnikRemote {

	public Collection<Podnik> getPodniky();

	public Collection<Podnik> getPodniky(Kategorie kategorie);

	public Collection<Podnik> getPodniky(Kurackost kurackost);

	public void zalozPodnik(Podnik p);

	public void upravPodnik(Podnik p);

	public Podnik getPodnik(int id);

	/**
	 * Dopočítá souřadnice podle adresy podniku.
	 * @return počet podniků u nichž jsme našli souřadnice
	 */
	public int dopocitejSouradnice();

	/**
	 * Zaznamená hlas uživatele
	 * @param podnik ID podniku
	 * @param hlas true = kuřácký | false = nekuřácký
	 * @param ipAdresa IP adresa uživatele, který hlasuje
	 */
	public void hlasuj(int podnik, boolean hlas, String ipAdresa);

	/**
	 * @return agregované výsledky hlasování pro daný podnik
	 */
	public VysledekHlasovani getVysledekHlasovani(Podnik podnik);

	/**
	 * @param k komentář, který se má přidat k podniku
	 * @param uloz true = vloží komentář | false = pouze zkontroluje (naformátuje obsah komentáře)
	 */
	public Komentar komentuj(Komentar k, boolean uloz) throws KomentarovaVyjimka, WikiSyntaxVyjimka;
}
