package cz.frantovo.nekurak.dto;

import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Agregovaný výsledek hlasování o tom,
 * zda se má v daném (jednom) podniku kouřit nebo ne.
 * @author fiki
 */
public class VysledekHlasovani {

	private static final Logger log = Logger.getLogger(VysledekHlasovani.class.getSimpleName());
	private int hlasuAno;
	private int hlasuNe;
	private Podnik podnik;

	public VysledekHlasovani(Podnik podnik) {
		this.podnik = podnik;
	}

	/**
	 * @return počet hlasů pro kuřácký podnik
	 */
	public int getHlasuAno() {
		return hlasuAno;
	}

	public void setHlasuAno(int pocet) {
		this.hlasuAno = pocet;
	}

	/**
	 * @return počet hlasů pro nekuřácký podnik
	 */
	public int getHlasuNe() {
		return hlasuNe;
	}

	public void setHlasuNe(int pocet) {
		this.hlasuNe = pocet;
	}

	public Boolean getSpokojenost() {
		int k = podnik.getKurackost().getId();

		if (k == 0 || (hlasuAno == 0 && hlasuNe == 0)) {
			/** neznámý stav → neznámá spokojenost */
			return null;
		} else if (k == 1 || k == 4) {
			/** zakouřený podnik */
			return hlasuAno > hlasuNe;
		} else if (k == 2) {
			/** nekuřácký podnik */
			return hlasuAno < hlasuNe;
		} else if (k == 3) {
			/** důkladně oddělené části → pokud hlasování vyšlo mezi 35% a 65% bude spokojenost */
			int soucet = hlasuAno + hlasuNe;
			return hlasuAno > 0.35 * soucet && hlasuAno < 0.65 * soucet;
		} else {
			log.log(Level.SEVERE, "Neznámá hodnota kuřáckosti: {0} u podniku: {1}", new Integer[]{k, podnik.getId()});
			return null;
		}
	}
}
