package cz.frantovo.nekurak.dto;

import java.io.Serializable;
import java.util.Locale;

/**
 * Uživatel se registruje na webu.
 * Tato třída obsahuje jen ty údaje, které se vyplňují do registračního formuláře.
 * Nakonec se převede na instanci třídy Uzivatel a uloží do databáze.
 * @author fiki
 */
public class PozadavekNaRegistraciUzivatele implements Serializable {

	/** Uživatelské jméno */
	private String prezdivka;
	/** Heslo ve tvaru, v jakém má být uloženo do databáze */
	private String heslo;
	/** Křestní jméno */
	private String jmeno;
	private String prijmeni;
	private String email;
	private Locale jazyk;

	public String getPrezdivka() {
		return prezdivka;
	}

	public void setPrezdivka(String prezdivka) {
		this.prezdivka = prezdivka;
	}

	public String getHeslo() {
		return heslo;
	}

	public void setHeslo(String heslo) {
		this.heslo = heslo;
	}

	public String getJmeno() {
		return jmeno;
	}

	public void setJmeno(String jmeno) {
		this.jmeno = jmeno;
	}

	public String getPrijmeni() {
		return prijmeni;
	}

	public void setPrijmeni(String prijmeni) {
		this.prijmeni = prijmeni;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public Locale getJazyk() {
		return jazyk;
	}

	public void setJazyk(Locale jazyk) {
		this.jazyk = jazyk;
	}

	/** Převede údaje z registrace do instance třídy Uzivatel */
	public Uzivatel getUzivatel() {
		Uzivatel u = new Uzivatel();

		u.setPrezdivka(prezdivka);
		u.setHeslo(heslo);
		u.setJmeno(jmeno);
		u.setPrijmeni(prijmeni);
		u.setEmail(email);

		return u;
	}
}
