package cz.frantovo.nekurak.dto;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * Podnik – hospoda, bar, kavárna…
 * @author fiki
 */
public class Podnik implements Serializable {

	private int id;
	private String nazev;
	private String popis;
	private String url;
	private String ulice;
	private Date datum;
	private Integer cisloPopisne;
	private String mesto;
	private String spravce;
	private List<Fotka> fotky = new ArrayList<Fotka>();
	private Set<Komentar> komentare = new HashSet<Komentar>();
	private Set<Kategorie> kategorie = new HashSet<Kategorie>();
	private Double sirka;
	private Double delka;
	private Kurackost kurackost = new Kurackost();
	private boolean schvaleny = false;

	public Podnik() {
	}

	public Podnik(int id, String nazev) {
		this.id = id;
		this.nazev = nazev;
	}

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public String getNazev() {
		return nazev;
	}

	public void setNazev(String nazev) {
		this.nazev = nazev;
	}

	public String getPopis() {
		return popis;
	}

	public void setPopis(String popis) {
		this.popis = popis;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	/**
	 * Získá z URL webové stránky podniku doménové jméno převedené na malá písmena.
	 * Např. z „http://www.Example.COM/index.html“ získá „www.example.com“.
	 * @return doménové jméno nebo null v případě chyby.
	 */
	public String getUrlDomena() {
		if (url == null) {
			return null;
		} else {
			try {
				URL u = new URL(url);
				String domena = u.getHost().toLowerCase();
				if (domena.length() > 0) {
					return domena;
				} else {
					return null;
				}
			} catch (Exception e) {
				return null;
			}
		}
	}

	public String getUlice() {
		return ulice;
	}

	public void setUlice(String ulice) {
		this.ulice = ulice;
	}

	public Date getDatum() {
		return datum;
	}

	public void setDatum(Date datum) {
		this.datum = datum;
	}

	public int getCisloPopisne() {
		return cisloPopisne;
	}

	public void setCisloPopisne(int cisloPopisne) {
		this.cisloPopisne = cisloPopisne;
	}

	public String getMesto() {
		return mesto;
	}

	public void setMesto(String mesto) {
		this.mesto = mesto;
	}

	public String getSpravce() {
		return spravce;
	}

	public void setSpravce(String spravce) {
		this.spravce = spravce;
	}

	public List<Fotka> getFotky() {
		return fotky;
	}

	public void setFotky(List<Fotka> fotky) {
		this.fotky = fotky;
	}

	public Double getSirka() {
		return sirka;
	}

	public void setSirka(Double sirka) {
		this.sirka = sirka;
	}

	public Double getDelka() {
		return delka;
	}

	public void setDelka(Double delka) {
		this.delka = delka;
	}

	public Set<Komentar> getKomentare() {
		return komentare;
	}

	public void setKomentare(Set<Komentar> komentare) {
		this.komentare = komentare;
	}

	public Set<Kategorie> getKategorie() {
		return kategorie;
	}

	public void setKategorie(Set<Kategorie> kategorie) {
		this.kategorie = kategorie;
	}

	public Kurackost getKurackost() {
		return kurackost;
	}

	public void setKurackost(Kurackost kurackost) {
		this.kurackost = kurackost;
	}

	public boolean isSchvaleny() {
		return schvaleny;
	}

	public void setSchvaleny(boolean schvaleny) {
		this.schvaleny = schvaleny;
	}
	/** Půdou a sklepem projedete bez nebezpečí. */
}
