package cz.frantovo.nekurak.dto;

import java.util.Date;

/**
 * Komentář k podniku
 * @author fiki
 */
public class Komentar {

	private int id;
	private int podnik;
	private String uzivatel;
	private Date datum;
	private String nadpis;
	private String komentar;
	private TYP typ;

	public TYP getTyp() {
		return typ;
	}

	public void setTyp(TYP typ) {
		this.typ = typ;
	}

	public enum TYP {

		PROSTY_TEXT,
		XHTML,
		MARKDOWN,
		TEXY
	}

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public int getPodnik() {
		return podnik;
	}

	public void setPodnik(int podnik) {
		this.podnik = podnik;
	}

	public String getUzivatel() {
		return uzivatel;
	}

	public void setUzivatel(String uzivatel) {
		this.uzivatel = uzivatel;
	}

	public Date getDatum() {
		return datum;
	}

	public void setDatum(Date datum) {
		this.datum = datum;
	}

	public String getNadpis() {
		return nadpis;
	}

	public void setNadpis(String nadpis) {
		this.nadpis = nadpis;
	}

	public String getKomentar() {
		return komentar;
	}

	public void setKomentar(String komentar) {
		this.komentar = komentar;
	}

	/**
	 * Zjišťujeme, zda uživatel nezapomněl na háčky a čárky.
	 * @return true, pokud text komentáře nebo předmět obsahují alespoň jeden znak s diakritikou
	 */
	public boolean isČeština() {
		return (komentar + nadpis).matches("(\\p{Space}|.)*(ě|š|č|ř|ž|ý|á|í|é|ú|ů|ť|ď)(\\p{Space}|.)*");
	}
}
