package cz.frantovo.nekurak.ext;

import cz.frantovo.nekurak.dto.Komentar.TYP;
import cz.frantovo.nekurak.vyjimky.WikiSyntaxVyjimka;
import org.junit.Before;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 * Testuje spíš dostupnost vzdálené služby a fungování samotného WikiSyntaxProcesor než implementaci javové části –
 * ta buď funguje, nebo nefunguje → není potřeba testovat moc do podrobna.
 * (testovat by se měla případná parametrizovatelnost – zatím žádná není)
 * @author fiki
 */
public class WikiSyntaxProcesorTest {

	private WikiSyntaxProcesor wikiSyntaxProcesor = new WikiSyntaxProcesor();
	private static final int CASOVY_LIMIT = 1000;

	@Before
	public void setUp() {
		wikiSyntaxProcesor.setMarkdownPříkaz(new String[]{"markdown"});
	}

	@Test(timeout = CASOVY_LIMIT)
	public void prostyText() throws WikiSyntaxVyjimka {
		testuj("", "", TYP.TEXY);
		testuj("", "", TYP.MARKDOWN);
		
		testuj("ahoj", "<p>ahoj</p>", TYP.TEXY);
		testuj("ahoj", "<p>ahoj</p>", TYP.MARKDOWN);
	}

	@Test(timeout = CASOVY_LIMIT)
	public void nadpisy() throws WikiSyntaxVyjimka {
		testuj("===Nadpis===", "<h1>Nadpis</h1>", TYP.TEXY);
		testuj("Nadpis\n======", "<h1>Nadpis</h1>", TYP.MARKDOWN);
	}

	private void testuj(String vstup, String pozadovanyVystup, TYP syntaxe) throws WikiSyntaxVyjimka {
		String vystup = wikiSyntaxProcesor.převeď(vstup, syntaxe);
		assertEquals(pozadovanyVystup, vystup.trim());
	}
}
