package cz.frantovo.nekurak.ext;

import cz.frantovo.nekurak.ext.Geo.Souradnice;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 * Testuje hlavně dostupnost a funkčnost vzdálené služby (Google).
 * @author fiki
 */
public class GeoTest {

	private Geo geo = new Geo();
	private static final int CASOVY_LIMIT = 1000;

	@Test(timeout = CASOVY_LIMIT)
	public void praha() {
		testuj("Praha, Czech Republic", 50.0878114, 14.4204598);
	}

	@Test(timeout = CASOVY_LIMIT)
	public void šanghaj() {
		// https://frantovo.cz/blog/?q=cina-šanghaj-mesto-lide :-)
		testuj("Shanghai, China", 31.230393, 121.473704);
	}

	@Test(timeout = CASOVY_LIMIT)
	public void dallas() {
		testuj("Dallas, TX", 32.802955, -96.769923);
	}

	@Test(timeout = CASOVY_LIMIT)
	public void moskva() {
		testuj("Moscow, Russia", 55.755786, 37.617633);
	}

	@Test
	public void loc() {
		Souradnice s = geo.new Souradnice(55.755786, 37.617633);
		assertEquals("Loc: 55.755786, 37.617633", s.getLoc());
	}

	private void testuj(String vstup, double pozadovanaSirka, double pozadovanaDelka) {
		Souradnice vystup = geo.getSouradnice(vstup);
		assertEquals(geo.new Souradnice(pozadovanaSirka, pozadovanaDelka), vystup);
	}
}
