package cz.frantovo.nekurak.ext;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * TODO: přesunout jinam a převést na EJB.
 * @author fiki
 */
public class Geo {

	private static final Logger log = Logger.getLogger(Geo.class.getSimpleName());

	/**
	 * Převede poštovní adresu na zeměpisné souřadnice.
	 * @param adresa
	 * @return souřadnice k dané adrese nebo null, v případě chyby.
	 */
	public Souradnice getSouradnice(String adresa) {
		try {

			/**
			 * TODO: naprosto zprasené → předělat →
			 * http://code.google.com/intl/cs/apis/maps/documentation/geocoding/#XMLParsing
			 */
			DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
			Document d = db.parse(sestavURL(adresa));
			NodeList mista = d.getElementsByTagName("location");
			Node misto = mista.item(0);
			NodeList potomci = misto.getChildNodes();
			String delka = null;
			String sirka = null;
			for (int i = 0; i < potomci.getLength(); i++) {
				Node p = potomci.item(i);
				if ("lat".equals(p.getNodeName())) {
					sirka = p.getTextContent();
				}
				if ("lng".equals(p.getNodeName())) {
					delka = p.getTextContent();
				}
			}

			if (sirka == null || delka == null) {
				log.log(Level.WARNING, "Selhalo zjišťování souřadnic – šířka nebo délka jsou null – pro adresu: {0}", adresa);
				return null;
			} else {
				return new Souradnice(Double.parseDouble(sirka), Double.parseDouble(delka));
			}
		} catch (Exception e) {
			log.log(Level.WARNING, "Selhalo zjišťování souřadnic pro adresu: " + adresa, e);
			return null;
		}
	}

	private static String sestavURL(String adresa) throws UnsupportedEncodingException {
		return "http://maps.google.com/maps/api/geocode/xml?sensor=false&address=" + URLEncoder.encode(adresa, "UTF-8");
	}

	public class Souradnice {

		private double sirka;
		private double delka;

		@Override
		public String toString() {
			return "šířka = " + sirka + "; délka = " + delka + ";";
		}

		@Override
		public boolean equals(Object o) {
			if (o instanceof Souradnice) {
				Souradnice s = (Souradnice) o;
				return s.sirka == sirka && s.delka == delka;
			} else {
				return false;
			}
		}

		@Override
		public int hashCode() {
			int hash = 5;
			hash = 79 * hash + (int) (Double.doubleToLongBits(this.sirka) ^ (Double.doubleToLongBits(this.sirka) >>> 32));
			hash = 79 * hash + (int) (Double.doubleToLongBits(this.delka) ^ (Double.doubleToLongBits(this.delka) >>> 32));
			return hash;
		}

		public Souradnice(double sirka, double delka) {
			this.sirka = sirka;
			this.delka = delka;
		}

		public String getLoc() {
			return "Loc: " + sirka + ", " + delka;
		}

		public double getDelka() {
			return delka;
		}

		public double getSirka() {
			return sirka;
		}

		public void setDelka(double delka) {
			this.delka = delka;
		}

		public void setSirka(double sirka) {
			this.sirka = sirka;
		}
	}
}
