package cz.frantovo.nekurak.email;

import cz.frantovo.nekurak.vyjimky.NekurakVyjimka;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.mail.Message.RecipientType;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;

/**
 * Nízkoúrovňová komponenta sloužící k odesílání e-mailů.
 * @author fiki
 */
@Stateless
@LocalBean
public class Postak {

	@Resource(lookup = "mail/nekurak.net")
	Session smtpRelace;
	private static final Logger log = Logger.getLogger(Postak.class.getSimpleName());
	private static String REGULARNI_EMAIL = "^[_a-zA-Z0-9\\.\\-]+@[_a-zA-Z0-9\\.\\-]+\\.[a-zA-Z]{2,4}$";

	public void odesliZpravu(Adresa komu, Adresa od, String predmet, String text) throws NekurakVyjimka {

		try {
			MimeMessage mimeZprava = new MimeMessage(smtpRelace);

			mimeZprava.addRecipient(RecipientType.TO, komu.getInternetAddress());
			if (od != null) {
				mimeZprava.setFrom(od.getInternetAddress());
			}
			mimeZprava.setSubject(predmet);
			mimeZprava.setText(text, "UTF-8");

			Transport.send(mimeZprava);
			log.log(Level.INFO, "Zpráva pro {0} byla odeslána.", komu);
		} catch (Exception e) {
			throw new NekurakVyjimka("Selhalo odesílání e-mailu pro: " + komu.getInternetAddress(), e);
		}
	}

	/**
	 * Zkontroluje e-mailovou adresu
	 * @param email adresa typu abcd@example.com
	 * @return true, pokud e-mail vyhovuje regulárnímu výrazu pro e-maily
	 */
	public static boolean isAdresaOk(String email) {
		return email != null && Pattern.matches(REGULARNI_EMAIL, email);
	}
}
