package cz.frantovo.nekurak.email;

import cz.frantovo.nekurak.vyjimky.NekurakVyjimka;
import java.io.UnsupportedEncodingException;
import javax.mail.internet.InternetAddress;

/**
 * Obalová třída, abychom předešli prosakování abstrakce.
 * Konstruktor InternetAddress totiž může vyhodit UnsupportedEncodingException výjimku,
 * která nás na téhle úrovni ale nezajímá.
 */
public class Adresa {

	private String jmeno;
	private String email;

	public Adresa(String email, String jmeno) {
		this.email = email;
		this.jmeno = jmeno;
	}

	public InternetAddress getInternetAddress() throws NekurakVyjimka {
		try {
			return new InternetAddress(email, jmeno);
		} catch (UnsupportedEncodingException e) {
			throw new NekurakVyjimka("Chyba při převodu na InternetAddress", e);
		}
	}
}
