package cz.frantovo.nekurak.ejb;

import cz.frantovo.nekurak.dao.PodnikDAO;
import cz.frantovo.nekurak.dto.Kategorie;
import cz.frantovo.nekurak.dto.Komentar;
import cz.frantovo.nekurak.dto.Kurackost;
import cz.frantovo.nekurak.dto.Podnik;
import cz.frantovo.nekurak.dto.VysledekHlasovani;
import cz.frantovo.nekurak.ext.Geo;
import cz.frantovo.nekurak.ext.Geo.Souradnice;
import cz.frantovo.nekurak.ext.WikiSyntaxProcesor;
import cz.frantovo.nekurak.util.Komentare;
import cz.frantovo.nekurak.vyjimky.KomentarovaVyjimka;
import cz.frantovo.nekurak.vyjimky.WikiSyntaxVyjimka;
import java.util.Collection;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.annotation.security.RolesAllowed;
import javax.ejb.EJB;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;

/**
 *
 * @author fiki
 */
@Stateless
public class PodnikEJB implements PodnikRemote {

	private static final Logger log = Logger.getLogger(PodnikEJB.class.getSimpleName());
	@EJB
	private PodnikDAO podnikDAO;
	@Resource
	private SessionContext ctx;
	
	private WikiSyntaxProcesor wikiSyntaxProcesor = new WikiSyntaxProcesor();

	@Override
	public Collection<Podnik> getPodniky() {
		Collection<Podnik> vysledek = podnikDAO.getPodniky();
		return vysledek;
	}

	@Override
	public Collection<Podnik> getPodniky(Kategorie kategorie) {
		Collection<Podnik> vysledek = podnikDAO.getPodniky(kategorie);
		return vysledek;
	}

	@Override
	public Collection<Podnik> getPodniky(Kurackost kurackost) {
		Collection<Podnik> vysledek = podnikDAO.getPodniky(kurackost);
		return vysledek;
	}

	@Override
	public Podnik getPodnik(int id) {
		return podnikDAO.getPodnik(id);
	}

	@Override
	@RolesAllowed("opravneny")
	public void zalozPodnik(Podnik p) {
		/**
		 * Podnik zakládáme jako neschválený a je potřeba ho dodatečně schválit,
		 * to může udělat jen správce a ne uživatel (TODO)
		 */
		p.setSchvaleny(false);
		p.setSpravce(ctx.getCallerPrincipal().getName());
		podnikDAO.zaloz(p);
		/** TODO: asynchronní počítání */
		dopocitejSouradnice(p, new Geo());
	}

	@Override
	@RolesAllowed("opravneny")
	public void upravPodnik(Podnik p) {
		podnikDAO.uloz(p);
	}

	@Override
	public int dopocitejSouradnice() {
		/**
		 * TODO: refaktorovat, změnit datové typy, souřadnice…
		 */
		Geo g = new Geo();
		int pocetAktualizovanych = 0;

		for (Podnik p : podnikDAO.getPodnikyBezSouradnic()) {
			if (dopocitejSouradnice(p, g)) {
				pocetAktualizovanych++;
			}
		}

		return pocetAktualizovanych;
	}

	/**
	 * Na základě adresy (ulice, číslo, město) se pokusí zjistit souřadnice a uloží je k podniku.
	 * @param p podnik
	 * @param g poskytovatel geografických služeb
	 * @return zda se souřadnice podařilo dopočítat
	 */
	private boolean dopocitejSouradnice(Podnik p, Geo g) {
		Souradnice s = g.getSouradnice(p.getUlice() + " " + p.getCisloPopisne() + ", " + p.getMesto());
		if (s != null) {
			p.setSirka(s.getSirka());
			p.setDelka(s.getDelka());
			podnikDAO.uloz(p);
			return true;
		} else {
			return false;
		}
	}

	@Override
	public void hlasuj(int podnik, boolean hlas, String ipAdresa) {

		podnikDAO.hlasuj(podnik, hlas, ipAdresa);
	}

	@Override
	public VysledekHlasovani getVysledekHlasovani(Podnik podnik) {
		return podnikDAO.getVysledekHlasovani(podnik);
	}

	private void kontrolaKomentare(Komentar k) throws WikiSyntaxVyjimka, KomentarovaVyjimka {
		k.setUzivatel(ctx.getCallerPrincipal().getName());
		k.setDatum(null);

		if (k.getKomentar() == null || k.getKomentar().length() < 1) {
			throw new KomentarovaVyjimka("Nechceme prázdné komentáře.", null);
		}

		/** Převedeme na XML */
		switch (k.getTyp()) {
			case PROSTY_TEXT:
				k.setKomentar(Komentare.upravProstyText(k.getKomentar()));
				break;
			case MARKDOWN:
				k.setKomentar(wikiSyntaxProcesor.převeď(k.getKomentar(), Komentar.TYP.MARKDOWN));
				break;
			case TEXY:
				k.setKomentar(wikiSyntaxProcesor.převeď(k.getKomentar(), Komentar.TYP.TEXY));
				break;
			case XHTML:
				k.setKomentar(Komentare.upravXHTML(k.getKomentar()));
				break;
		}
		/** Přidáme kořenový element */
		k.setKomentar(Komentare.obal(k.getKomentar()));

		/** Zkontrolujeme XML */
		Komentare.zkontroluj(k.getKomentar());
	}

	@Override
	@RolesAllowed("opravneny")
	public Komentar komentuj(Komentar k, boolean uloz) throws KomentarovaVyjimka, WikiSyntaxVyjimka {
		kontrolaKomentare(k);
		if (uloz) {
			podnikDAO.zaloz(k);
		}
		return k;
	}
}
