package cz.frantovo.nekurak.ejb;

import cz.frantovo.nekurak.dao.ClanekDAO;
import cz.frantovo.nekurak.dto.Clanek;
import java.util.Collection;
import javax.annotation.security.RolesAllowed;
import javax.ejb.EJB;
import javax.ejb.Stateless;

/**
 * Redakční část – správa článků/stránek.
 * @author fiki
 */
@Stateless
public class ClanekEJB implements ClanekRemote {

	@EJB
	private ClanekDAO clanekDAO;

	@Override
	public Clanek getClanek(int id) {
		return clanekDAO.getClanek(id);
	}

	@Override
	public Collection<Clanek> getClanky() {
		return clanekDAO.getClanky();
	}

	@Override
	@RolesAllowed("redaktor")
	public int zalozClanek(Clanek clanek) {
		return clanekDAO.zalozClanek(clanek);
	}

	@Override
	@RolesAllowed("redaktor")
	public void upravClanek(Clanek clanek) {
		clanekDAO.upravClanek(clanek);
	}

	@Override
	@RolesAllowed("redaktor")
	public void smazClanek(Clanek clanek) {
		clanekDAO.smazClanek(clanek);
	}
}
