package cz.frantovo.nekurak.dao;

import cz.frantovo.nekurak.dto.Kategorie;
import cz.frantovo.nekurak.dto.Komentar;
import cz.frantovo.nekurak.dto.Kurackost;
import cz.frantovo.nekurak.dto.Podnik;
import cz.frantovo.nekurak.dto.VysledekHlasovani;
import cz.frantovo.superDAO.SuperDAO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

/**
 *
 * @author fiki
 */
@Stateless
@LocalBean
public class PodnikDAO extends SuperDAO {

	@PersistenceContext(unitName = DAO.PU)
	private EntityManager em;

	private enum SQL {

		HLASOVANI_INSERT,
		HLASOVANI_SELECT
	}

	/**
	 * @return schválené podniky
	 */
	public Collection<Podnik> getPodniky() {
		Query dotaz = em.createQuery("FROM " + DAO.t(Podnik.class) + " p WHERE p.schvaleny = true ORDER BY datum DESC");
		return dotaz.getResultList();
	}

	/**
	 * @return podniky, které nemají souřadnice (null, null), včetně neschválených
	 */
	public Collection<Podnik> getPodnikyBezSouradnic() {
		Query dotaz = em.createQuery("FROM " + DAO.t(Podnik.class) + " p WHERE sirka IS NULL AND delka IS NULL");
		return dotaz.getResultList();
	}

	/**
	 * @param kategorie jedna kategorie
	 * @return podniky určité kategorie (jen schválené)
	 */
	public Collection<Podnik> getPodniky(Kategorie kategorie) {
		Query dotaz = em.createQuery("SELECT p FROM " + DAO.t(Podnik.class) + " p INNER JOIN p.kategorie k WHERE k = :kategorie AND p.schvaleny = true ORDER BY datum DESC");
		dotaz.setParameter("kategorie", kategorie);
		return dotaz.getResultList();
	}

	public Collection<Podnik> getPodniky(Kurackost kurackost) {
		Query dotaz = em.createQuery("FROM " + DAO.t(Podnik.class) + " p WHERE p.kurackost = :kurackost AND p.schvaleny = true ORDER BY datum DESC");
		dotaz.setParameter("kurackost", kurackost);
		return dotaz.getResultList();
	}


	public Podnik getPodnik(int id) {
		return em.find(Podnik.class, id);
	}

	public void zaloz(Podnik p) {
		if (p.getDatum() == null) {
			p.setDatum(new Date());
		}

		em.persist(p);
	}

	public void uloz(Podnik p) {
		if (p.getDatum() == null) {
			p.setDatum(new Date());
		}

		em.merge(p);
	}

	public void zaloz(Komentar k) {
		if (k.getDatum() == null) {
			k.setDatum(new Date());
		}

		em.persist(k);
	}

	/**
	 * Zaznamená hlas uživatele, zda se v podniku má nebo nemá kouřit
	 * @param podnik podnik o kterém se hlasuje
	 * @param hlas true = kouřit | false = nekouřit
	 * @param ipAdresa identifikujeme pomocí ní uživatele
	 */
	public void hlasuj(int podnik, boolean hlas, String ipAdresa) {
		Query insert = em.createNativeQuery(getSQL(SQL.HLASOVANI_INSERT));
		insert.setParameter("podnik", podnik);
		insert.setParameter("hlas", hlas);
		insert.setParameter("ip_adresa", ipAdresa);
		insert.executeUpdate();
	}

	public VysledekHlasovani getVysledekHlasovani(Podnik podnik) {
		VysledekHlasovani vysledek = new VysledekHlasovani(podnik);
		Query select = em.createNativeQuery(getSQL(SQL.HLASOVANI_SELECT));
		select.setParameter("podnik", podnik.getId());
		List<Object[]> vysledekDotazu = select.getResultList();

		for (Object[] radek : vysledekDotazu) {
			/** Transponujeme výsledek dotazu */
			if ((Boolean) radek[0]) {
				vysledek.setHlasuAno((Integer) radek[1]);
			} else {
				vysledek.setHlasuNe((Integer) radek[1]);
			}
		}

		return vysledek;
	}
}
