package cz.frantovo.nekurak.dao;

import cz.frantovo.nekurak.dto.Clanek;
import java.util.Collection;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

/**
 *
 * @author fiki
 */
@Stateless
@LocalBean
public class ClanekDAO {

	@PersistenceContext(unitName = DAO.PU)
	private EntityManager em;

	public Clanek getClanek(int id) {
		return em.find(Clanek.class, id);
	}

	public Collection<Clanek> getClanky() {
		Query dotaz = em.createQuery("FROM " + DAO.t(Clanek.class) + " c ORDER BY id");
		return dotaz.getResultList();
	}

	public int zalozClanek(Clanek clanek) {
		em.persist(clanek);
		return clanek.getId();
	}

	public void upravClanek(Clanek clanek) {
		System.out.println("XXXXXXX: upravuji článek: " + clanek.getId());
		em.merge(clanek);
	}

	public void smazClanek(Clanek clanek) {
		clanek = em.merge(clanek);
		em.remove(clanek);
	}
}
